IF EXISTS ( SELECT 1 FROM SYS.TRIGGERS WHERE NAME = 'TRG_ATUALIZA_SALDO_ESTOQUE_EST_PROD_CPL' )
BEGIN
	DROP TRIGGER TRG_ATUALIZA_SALDO_ESTOQUE_EST_PROD_CPL
END
GO
CREATE TRIGGER TRG_ATUALIZA_SALDO_ESTOQUE_EST_PROD_CPL on [dbo].[PDV_VD] 
AFTER UPDATE AS
BEGIN

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221123
'Job.................:  
'Nome................:  TRG_ATUALIZA_SALDO_ESTOQUE_EST_PROD_CPL
'Objetivo............:	trigger responsavel em atualizar tabela EST_PROD_CPL sempre que ocorrer uma alterao na pdv_vd. Criado para ajuste de estoque 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2022-11-23
'Alterado por........: 
'Criado por..........:  Marcos Barros
'=======================================================================================

*/

	DECLARE @CD_VD INT;
	
	SELECT @CD_VD = CD_VD FROM INSERTED;

	UPDATE EST_PROD_CPL
		SET CD_EMP = 1
		--, DT_ULT_ATU = CURRENT_TIMESTAMP -- TESTE DE ALTERAO
	FROM 
		EST_PROD_CPL 
		INNER JOIN PDV_VD_IT ON
			EST_PROD_CPL.CD_EMP = PDV_VD_IT.CD_EMP
			AND dbo.EST_PROD_CPL.CD_FILIAL = PDV_VD_IT.CD_FILIAL
			AND dbo.EST_PROD_CPL.CD_PROD = PDV_VD_IT.CD_PROD
		INNER JOIN PDV_VD ON 
			PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP
			AND PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL
			AND PDV_VD.CD_VD = PDV_VD_IT.CD_VD
	WHERE 
		PDV_VD_IT.CD_VD = @CD_VD;


/*
-- SCRIPT PARA CONSULTAR OQUE VAI SER ALTERADO 

SELECT EST_PROD_CPL.DT_IMP, EST_PROD_CPL.DT_ULT_ATU, EST_PROD_CPL.DT_ATUALIZA_PARAM, EST_PROD_CPL.DT_IMP, EST_PROD_CPL.CD_PROD, PDV_VD.CD_VD, * 
FROM 
	EST_PROD_CPL 
	INNER JOIN PDV_VD_IT ON
		EST_PROD_CPL.CD_EMP = PDV_VD_IT.CD_EMP
		AND dbo.EST_PROD_CPL.CD_FILIAL = PDV_VD_IT.CD_FILIAL
		AND dbo.EST_PROD_CPL.CD_PROD = PDV_VD_IT.CD_PROD
	INNER JOIN PDV_VD ON 
		PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP
		AND PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL
		AND PDV_VD.CD_VD = PDV_VD_IT.CD_VD
WHERE 
	PDV_VD.CD_VD = 33942
*/

END;
